<?php

class DbOperationF
{

    //Database connection link
    private $con;

    //Class constructor
    function __construct()
    {
        
        // //Getting the DbConnect.php file
           require_once dirname(__FILE__) . '/../DbConnect.php';
           

        //require_once '../DbConnect.php';

        // //Creating a DbConnect object to connect to the database
         $db = new DbConnect();
        // //Initializing our connection link of this class
        // //by calling the method connect of DbConnect class
       $this->con = $db->connect();
    }


//================================
//Ecoway Functions 
//================================

//--------------------------------
//take admin token 
//--------------------------------
public function getAdminTokens(){
        $usertype="admin";
         	
        $stmt = $this->con->prepare("SELECT DISTINCT f.token from fcm_token f WHERE  f.user_type=?");
        $stmt->bind_param("s", $usertype);
        $stmt->execute();
        $stmt->bind_result($tokenr);
 
        $tokens = array(); 
        while ($stmt->fetch()) {
              
            array_push($tokens, $tokenr);
            
        }
        return $tokens;
    } 
    
    
    
 public function getTokensForRejectorder($customerid){

            $usertypeA="customer";
            $usertypec="admin";
           
         	
        $stmt = $this->con->prepare("SELECT DISTINCT f.token from fcm_token f WHERE (f.user_type=? AND f.user_id=?) OR (f.user_type=?)");
        $stmt->bind_param("sis", $usertypeA,$customerid,$usertypec);
        $stmt->execute();
        $stmt->bind_result($tokenr);
 
            $tokens = array(); 
        while ($stmt->fetch()) {
              
            array_push($tokens, $tokenr);
            
        }
        return $tokens;
    }
        

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------REF---Code-----------------------------------------------------------------
	 
    //getting all tokens to send push to all devices
    public function getAllTokens($usertype){
            
        $stmt = $this->con->prepare("SELECT token from fcm_token WHERE user_type=?");
        $stmt->bind_param("s", $usertype);
        $stmt->execute();
         
         //$stmt->bind_result($token);
         $result = $stmt->get_result();
       
        $tokens = array(); 
        
        while($token = $result->fetch_assoc()){
           
            array_push($tokens, $token['token']);
            
        }
        return $tokens;
       
    }

 public function getTokensForOrder(){
        $orderstatus="pending";
        $stmt1 = $this->con->prepare("SELECT order_id FROM tbl_orders WHERE status=? AND date_time < DATE_SUB(NOW(), INTERVAL 20 MINUTE)");
        $stmt1->bind_param("s", $orderstatus);
        $stmt1->execute();
        $stmt1->store_result();	
        if($stmt1->num_rows > 0) {
        $usertypeA="admin";
         $usertypeb="subadmin";
         
        $stmt = $this->con->prepare("SELECT token from fcm_token WHERE user_type=? OR user_type=?");
        $stmt->bind_param("ss", $usertypeA,$usertypeb);
        $stmt->execute();
         $result = $stmt->get_result();
        $tokens = array(); 
        while($token = $result->fetch_assoc()){
            array_push($tokens, $token['token']);
            
        }
  
        return $tokens;
        }
        else{
             return 0;
            
        }
     
         
       
    }
    public function getTokensForStock($outletid){
     
         $usertypeb="deliBoy";
          
          $stmt = $this->con->prepare("SELECT DISTINCT token from fcm_token  WHERE user_type=? AND outlet_id=?");
        //$stmt = $this->con->prepare("SELECT DISTINCT f.token from fcm_token f,tbl_staff_to_outlet s WHERE f.user_type=? AND f.user_id=s.staff_id AND s.outlet_id=?");
        $stmt->bind_param("si", $usertypeb,$outletid);
        $stmt->execute();
         $result = $stmt->get_result();
        $tokens = array(); 
        while($token = $result->fetch_assoc()){
            array_push($tokens, $token['token']);
            
        }
  
        return $tokens;
     
         
       
    }
    
    
 
public function getTokensForApproveorder($customerid){

            $usertypeA="customer";
      
         
         	
        $stmt = $this->con->prepare("SELECT DISTINCT f.token from fcm_token f WHERE (f.user_type=? AND f.user_id=?)");
        $stmt->bind_param("si", $usertypeA,$customerid);
        $stmt->execute();
        $stmt->bind_result($tokenr);
 
            $tokens = array(); 
        while ($stmt->fetch()) {
              
            array_push($tokens, $tokenr);
            
        }
        
        // $result = $stmt->get_result();
         
    
        
        // while($token = $result->fetch_assoc()){
        //     echo "jijode".$token['token'];
            
            
        // }
        
  
        return $tokens;
    }
   public function getTokensForneworderdb($dboyid){

           
      
           $usertyped ="deliveryboy";
         	
        $stmt = $this->con->prepare("SELECT DISTINCT f.token from fcm_token f WHERE (f.user_type=? AND f.user_id=?)");
        $stmt->bind_param("si",$usertyped,$dboyid);
        $stmt->execute();
        $stmt->bind_result($tokenr);
 
            $tokens = array(); 
        while ($stmt->fetch()) {
              
            array_push($tokens, $tokenr);
            
        }
        
        // $result = $stmt->get_result();
         
    
        
        // while($token = $result->fetch_assoc()){
        //     echo "jijode".$token['token'];
            
            
        // }
        
  
        return $tokens;
    } 
   
    
  public function getCustTokensForNewOrder($cusid){
        
      
        $usertypeA="customer";
        
         
        $stmt = $this->con->prepare("SELECT DISTINCT token FROM fcm_token WHERE user_id=? AND user_type=?");
        $stmt->bind_param("is", $cusid,$usertypeA);
        $stmt->execute();
         $result = $stmt->get_result();
        $tokens = array(); 
        while($token = $result->fetch_assoc()){
            array_push($tokens, $token['token']);
            
        }
  
        return $tokens;
       
     
         
       
    }    


    //getting a specified token to send push to selected device
    public function getTokenByEmail($email){
        $stmt = $this->con->prepare("SELECT token FROM devices WHERE email = ?");
        $stmt->bind_param("s",$email);
        $stmt->execute(); 
        $result = $stmt->get_result()->fetch_assoc();
        return array($result['token']);        
    }

    //getting all the registered devices from database 
    public function getAllDevices(){
        $stmt = $this->con->prepare("SELECT * FROM devices");
        $stmt->execute();
        $result = $stmt->get_result();
        return $result; 
    }
}